<?php
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/functions.php';

$slug = $_GET['artist'] ?? '';
$artist = find_artist_by_slug($slug);

if (!$artist) {
    http_response_code(404);
    echo "Artist not found";
    exit;
}

$ft = $artist['featured_track'] ?? [];
$videos = $artist['videos'] ?? [];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title><?= htmlspecialchars($artist['name']) ?> • Artist Profile | Londons Energy Radio</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;600;800&family=Inter:wght@300;400;500;700&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
  <link rel="stylesheet" href="assets/css/artist-profile.css" />
</head>
<body>
  <div class="page-bg"></div>

  <div class="shell">
    <!-- HERO -->
    <header class="hero">
      <div class="hero-banner" style="background-image:url('<?= htmlspecialchars($artist['hero_banner']) ?>');"></div>
      <div class="hero-overlay">
        <div>
          <div class="hero-main-tag">
            <span class="dot"></span>
            <span>Featured • Londons Energy Radio</span>
          </div>

          <h1 class="hero-title"><?= htmlspecialchars($artist['name']) ?></h1>
          <div class="hero-subtitle"><?= htmlspecialchars($artist['tagline']) ?></div>

          <div class="hero-quote">
            <?= nl2br(htmlspecialchars($artist['quote'])) ?>
            <?php if (!empty($artist['quote_credit'])): ?>
              <span class="credit"><?= htmlspecialchars($artist['quote_credit']) ?></span>
            <?php endif; ?>
          </div>

          <?php if (!empty($ft['title'])): ?>
          <div class="hero-cta-row">
            <button class="btn-neon" id="scrollToTrack">
              <i class="fa-solid fa-play"></i>
              Listen to <?= htmlspecialchars($ft['title'] . ' ' . ($ft['subtitle'] ?? '')) ?>
            </button>
            <?php if (!empty($artist['socials']['youtube'])): ?>
              <a href="<?= htmlspecialchars($artist['socials']['youtube']) ?>" target="_blank" rel="noopener" class="btn-ghost">
                <i class="fa-brands fa-youtube"></i>
                YouTube Channel
              </a>
            <?php endif; ?>
          </div>
          <?php endif; ?>
        </div>

        <div class="hero-side">
          <div class="artist-photo-wrap">
            <div class="artist-photo">
              <img src="<?= htmlspecialchars($artist['profile_image']) ?>" alt="<?= htmlspecialchars($artist['name']) ?> portrait" />
            </div>
          </div>
          <div class="hero-side-label">Artist • <?= htmlspecialchars($artist['name']) ?></div>
          <div class="hero-socials">
            <?php if (!empty($artist['socials']['instagram'])): ?>
              <a class="social-pill" href="<?= htmlspecialchars($artist['socials']['instagram']) ?>" target="_blank" rel="noopener">
                <i class="fa-brands fa-instagram"></i>
                Instagram
              </a>
            <?php endif; ?>
            <?php if (!empty($artist['socials']['youtube'])): ?>
              <a class="social-pill" href="<?= htmlspecialchars($artist['socials']['youtube']) ?>" target="_blank" rel="noopener">
                <i class="fa-brands fa-youtube"></i>
                YouTube
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </header>

    <main>
      <!-- BIOGRAPHY -->
      <section class="section-card">
        <div class="section-card-inner">
          <div class="section-title-row">
            <div class="section-title">
              Biography
              <span class="bar"></span>
            </div>
          </div>
          <div class="section-body">
            <?php foreach (($artist['bio'] ?? []) as $p): ?>
              <p><?= htmlspecialchars($p) ?></p>
            <?php endforeach; ?>
          </div>
        </div>
      </section>

      <!-- FEATURED TRACK -->
      <?php if (!empty($ft['audio_url'])): ?>
      <section class="section-card" id="featuredTrack">
        <div class="section-card-inner">
          <div class="section-title-row">
            <div class="section-title">
              Featured Track on Londons Energy
              <span class="bar"></span>
            </div>
          </div>

          <div class="track-card">
            <div class="track-meta">
              <div class="track-tag">Exclusive Spin • Now Playing</div>
              <div class="track-title">
                <?= htmlspecialchars($ft['title']) ?>
                <?php if (!empty($ft['subtitle'])): ?>
                  <span><?= htmlspecialchars($ft['subtitle']) ?></span>
                <?php endif; ?>
              </div>
              <div class="track-note">
                <?= nl2br(htmlspecialchars($ft['note'] ?? '')) ?>
              </div>
            </div>

            <div class="track-player-shell">
              <div class="track-player" id="trackPlayer">
                <div style="display:flex; gap:0.8rem; align-items:center;">
                  <div class="track-art">
                    <img src="<?= htmlspecialchars($ft['artwork'] ?? $artist['profile_image']) ?>" alt="Single artwork" />
                  </div>
                  <div class="track-main-info">
                    <h4><?= htmlspecialchars($ft['title']) ?> <?= htmlspecialchars($ft['subtitle'] ?? '') ?></h4>
                    <span><?= htmlspecialchars($ft['artist_name'] ?? $artist['name']) ?></span>
                    <div class="eq-bars">
                      <div class="eq-bar"></div>
                      <div class="eq-bar"></div>
                      <div class="eq-bar"></div>
                      <div class="eq-bar"></div>
                      <div class="eq-bar"></div>
                    </div>
                    <div class="player-status" id="playerStatus">Ready to play</div>
                  </div>
                </div>

                <div class="track-controls">
                  <button class="play-btn" id="playToggle" aria-label="Play / Pause">
                    <i class="fa-solid fa-play" id="playIcon"></i>
                  </button>
                  <input type="range" min="0" max="1" step="0.01" value="0.9" class="volume-slider" id="volumeSlider" />
                </div>

                <audio id="audioSource">
                  <source src="<?= htmlspecialchars($ft['audio_url']) ?>" type="audio/mpeg" />
                  Your browser does not support the audio element.
                </audio>
              </div>
            </div>
          </div>
        </div>
      </section>
      <?php endif; ?>

      <!-- VIDEO EMBEDS -->
      <?php if (!empty($videos)): ?>
      <section class="section-card">
        <div class="section-card-inner">
          <div class="section-title-row">
            <div class="section-title">
              Visuals &amp; Videos
              <span class="bar"></span>
            </div>
          </div>

          <div class="section-body">
            <p>
              Step into the visual world of <?= htmlspecialchars($artist['name']) ?>.
            </p>

            <div class="video-grid">
              <?php foreach ($videos as $video): ?>
              <div>
                <div class="video-frame">
                  <iframe
                    src="https://www.youtube.com/embed/<?= htmlspecialchars($video['youtube_id']) ?>"
                    title="<?= htmlspecialchars($artist['name']) ?> video"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                    allowfullscreen>
                  </iframe>
                </div>
                <div class="video-caption">
                  <?= htmlspecialchars($video['caption']) ?>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      </section>
      <?php endif; ?>
    </main>

    <footer>
      Artist Profile • <span><?= htmlspecialchars($artist['name']) ?></span> • Hosted by Londons Energy Radio
    </footer>
  </div>

  <script>
    // Smooth scroll
    const scrollBtn = document.getElementById("scrollToTrack");
    if (scrollBtn) {
      scrollBtn.addEventListener("click", function() {
        const target = document.getElementById("featuredTrack");
        if (target) target.scrollIntoView({ behavior: "smooth", block: "start" });
      });
    }

    const audio = document.getElementById("audioSource");
    const playToggle = document.getElementById("playToggle");
    const playIcon = document.getElementById("playIcon");
    const volumeSlider = document.getElementById("volumeSlider");
    const playerStatus = document.getElementById("playerStatus");
    const trackPlayer = document.getElementById("trackPlayer");

    if (audio && playToggle) {
      let isPlaying = false;

      playToggle.addEventListener("click", function () {
        if (!isPlaying) {
          audio.play().then(() => {
            isPlaying = true;
            trackPlayer.classList.add("is-playing");
            playIcon.classList.remove("fa-play");
            playIcon.classList.add("fa-pause");
            playerStatus.textContent = "Now playing: <?= htmlspecialchars($ft['title'] ?? '') ?>";
          }).catch(() => {
            playerStatus.textContent = "Unable to autoplay. Tap again to play.";
          });
        } else {
          audio.pause();
          isPlaying = false;
          trackPlayer.classList.remove("is-playing");
          playIcon.classList.remove("fa-pause");
          playIcon.classList.add("fa-play");
          playerStatus.textContent = "Paused";
        }
      });

      audio.addEventListener("ended", function () {
        isPlaying = false;
        trackPlayer.classList.remove("is-playing");
        playIcon.classList.remove("fa-pause");
        playIcon.classList.add("fa-play");
        playerStatus.textContent = "Playback finished";
      });

      if (volumeSlider) {
        volumeSlider.addEventListener("input", function () {
          audio.volume = parseFloat(this.value);
        });
        audio.volume = parseFloat(volumeSlider.value);
      }
    }
  </script>
</body>
</html>
