// Mobile navigation drawer
(() => {
  // Only enable the drawer behavior when JS is available.
  document.documentElement.classList.add('js');

  const toggleBtn = document.querySelector('.nav-toggle');
  const overlay = document.querySelector('.nav-overlay');
  const nav = document.getElementById('primary-nav');

  if (!toggleBtn || !nav) return;

  const setExpanded = (expanded) => {
    toggleBtn.setAttribute('aria-expanded', expanded ? 'true' : 'false');
  };

  const closeNav = () => {
    document.body.classList.remove('nav-open');
    setExpanded(false);
  };

  toggleBtn.addEventListener('click', () => {
    const isOpen = document.body.classList.toggle('nav-open');
    setExpanded(isOpen);
  });

  if (overlay) {
    overlay.addEventListener('click', closeNav);
  }

  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') closeNav();
  });

  // Close drawer when a link is clicked
  nav.addEventListener('click', (e) => {
    const target = e.target;
    if (target && target.closest && target.closest('a')) {
      closeNav();
    }
  });
})();
